import { Card, CardContent } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';
import { Button } from '@/components/ui/button';
import { 
  GraduationCap, 
  Code, 
  Award, 
  Target,
  Users,
  Lightbulb,
  Download
} from 'lucide-react';

export const AboutSection = () => {
  const skills = [
    { name: 'JavaScript/TypeScript', level: 95 },
    { name: 'React/Next.js', level: 90 },
    { name: 'Python', level: 85 },
    { name: 'Node.js', level: 88 },
    { name: 'Database Design', level: 82 },
    { name: 'Cloud Architecture', level: 78 }
  ];

  const achievements = [
    {
      icon: GraduationCap,
      title: 'Team Qualifications',
      description: 'Selected from excellent performers',
      highlight: 'Academic Excellence'
    },
    {
      icon: Code,
      title: '5+ Years Experience',
      description: 'Software Engineering',
      highlight: 'Industry Expertise'
    },
    {
      icon: Award,
      title: '50+ Projects',
      description: 'Successfully Delivered',
      highlight: 'Proven Track Record'
    },
    {
      icon: Users,
      title: '100% Satisfaction',
      description: 'Client Success Rate',
      highlight: 'Quality Assured'
    }
  ];

  const values = [
    {
      icon: Target,
      title: 'Excellence',
      description: 'Delivering exceptional quality in every project'
    },
    {
      icon: Lightbulb,
      title: 'Innovation',
      description: 'Embracing cutting-edge technologies and solutions'
    },
    {
      icon: Users,
      title: 'Collaboration',
      description: 'Working closely with clients to achieve their goals'
    }
  ];

  return (
    <section id="about" className="py-20 bg-muted/30">
      <div className="container mx-auto px-4 sm:px-6 lg:px-8">
        {/* Section Header */}
        <div className="text-center mb-16">
          <Badge variant="outline" className="mb-4 border-primary text-primary">
            About Mathenoid ICT Lab
          </Badge>
          <h2 className="text-3xl sm:text-4xl lg:text-5xl font-bold mb-6">
            Meet
            <span className="block gradient-hero bg-clip-text text-transparent">
              Kelvin Nyaga Mbugua
            </span>
          </h2>
          <p className="text-lg text-muted-foreground max-w-2xl mx-auto">
            A passionate software Engineering Team, transforming complex challenges 
            into elegant digital solutions through Software Engineering expertise.
          </p>
        </div>

        <div className="grid lg:grid-cols-2 gap-12 items-center mb-16">
          {/* Profile Content */}
          <div className="space-y-8">
            <div>
              <h3 className="text-2xl font-bold mb-4 text-foreground">Professional Journey</h3>
              <p className="text-muted-foreground leading-relaxed mb-4">
                With a solid foundation in various concepts and Software Engineering slills, 
                we have dedicated over 5 years to crafting innovative software solutions that bridge 
                the gap between complex Software Engineering concepts and practical business applications.
              </p>
              <p className="text-muted-foreground leading-relaxed">
                Mathenoid ICT Lab was founded on the principle that technology should be accessible, 
                efficient, and transformative. Every project we undertake is approached with analytical 
                precision and creative problem-solving.
              </p>
            </div>

            {/* Skills Progress */}
            <div>
              <h4 className="text-lg font-semibold mb-4">Technical Expertise</h4>
              <div className="space-y-4">
                {skills.map((skill, index) => (
                  <div key={index}>
                    <div className="flex justify-between mb-1">
                      <span className="text-sm font-medium">{skill.name}</span>
                      <span className="text-sm text-primary">{skill.level}%</span>
                    </div>
                    <div className="w-full bg-border rounded-full h-2">
                      <div 
                        className="bg-gradient-to-r from-primary to-accent h-2 rounded-full transition-all duration-1000"
                        style={{ width: `${skill.level}%` }}
                      ></div>
                    </div>
                  </div>
                ))}
              </div>
            </div>

           
          </div>

          {/* Achievements Grid */}
          <div className="grid grid-cols-1 sm:grid-cols-2 gap-6">
            {achievements.map((achievement, index) => {
              const Icon = achievement.icon;
              return (
                <Card key={index} className="group hover:shadow-lg transition-all duration-300 hover:-translate-y-1">
                  <CardContent className="p-6 text-center">
                    <div className="w-12 h-12 mx-auto mb-4 bg-gradient-to-br from-primary to-accent rounded-lg flex items-center justify-center group-hover:scale-110 transition-transform">
                      <Icon className="w-6 h-6 text-white" />
                    </div>
                    <Badge variant="secondary" className="mb-2 text-xs">
                      {achievement.highlight}
                    </Badge>
                    <h4 className="font-semibold text-foreground mb-1">{achievement.title}</h4>
                    <p className="text-sm text-muted-foreground">{achievement.description}</p>
                  </CardContent>
                </Card>
              );
            })}
          </div>
        </div>

        {/* Company Values */}
        <div>
          <h3 className="text-2xl font-bold text-center mb-8">Our Core Values</h3>
          <div className="grid md:grid-cols-3 gap-8">
            {values.map((value, index) => {
              const Icon = value.icon;
              return (
                <Card key={index} className="text-center group hover:shadow-lg transition-all duration-300">
                  <CardContent className="p-8">
                    <div className="w-16 h-16 mx-auto mb-4 bg-gradient-to-br from-primary to-steel-blue-light rounded-full flex items-center justify-center group-hover:scale-110 transition-transform">
                      <Icon className="w-8 h-8 text-white" />
                    </div>
                    <h4 className="text-xl font-semibold mb-3 group-hover:text-primary transition-colors">
                      {value.title}
                    </h4>
                    <p className="text-muted-foreground">{value.description}</p>
                  </CardContent>
                </Card>
              );
            })}
          </div>
        </div>
      </div>
    </section>
  );
};