import { Badge } from '@/components/ui/badge';
import { Button } from '@/components/ui/button';
import { Separator } from '@/components/ui/separator';
import { 
  Heart,
  Mail,
  Phone,
  MapPin,
  Linkedin,
  Github,
  Twitter,
  ArrowUp,
  Zap,
  Cpu,
  Database,
  Globe
} from 'lucide-react';
import { Link } from 'react-router-dom';

export const Footer = () => {
  const currentYear = new Date().getFullYear();

  const quickLinks = [
    { name: 'HOME', href: 'home' },
    { name: 'SERVICES', href: 'services' },
    { name: 'PROJECTS', href: 'projects' },
    { name: 'ABOUT', href: 'about' },
    { name: 'CONTACT', href: 'contact' }
  ];

  const cyberServices = [
    'Web Systems',
    'Mobile Apps',
    'Data  Analytics',
    'AI Solution',
    'Software maintenance',
    'Cyber Defense '
  ];

  const socialLinks = [
    { icon: Linkedin, href: '#', label: 'LinkedIn Neural Link' },
    { icon: Github, href: '#', label: 'GitHub Code Vault' },
    { icon: Twitter, href: '#', label: 'Twitter Data Stream' }
  ];

  const scrollToTop = () => {
    window.scrollTo({ top: 0, behavior: 'smooth' });
  };

  const CyberIcon = ({ icon: Icon, className = "" }: { icon: any, className?: string }) => (
    <div className={`relative group ${className}`}>
      <Icon className="w-4 h-4 group-hover:transition-all duration-300" />
      <div className="absolute inset-0 bg-primary/20 rounded-full scale-0 group-hover:scale-150 transition-transform duration-300 opacity-0 group-hover:opacity-100"></div>
    </div>
  );

  return (
    <footer className="relative bg-background border-t neon-border overflow-hidden">
      {/* Cyber Background */}
      <div className="absolute inset-0 opacity-5">
        <div className="w-full h-full holographic"></div>
      </div>
      
      {/* Scanning lines */}
      <div className="absolute top-0 left-0 right-0 h-px bg-gradient-to-r from-transparent via-primary to-transparent animate-data-stream"></div>
      
      {/* Main Footer Content */}
      <div className="container mx-auto px-4 sm:px-6 lg:px-8 py-20 relative z-10">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12">
          {/* Cyber Company Info */}
          <div className="lg:col-span-1">
            {/* Futuristic Logo */}
                     <Link to="/" className="flex items-center group hover:scale-105 transition-transform duration-300 flex-shrink-0 pb-3">
                       <div className="relative">
                         <Zap className="w-6 h-6 sm:w-8 sm:h-8 text-primary mr-2 sm:mr-3 group-hover:rotate-12 transition-transform duration-300" />
                         <div className="absolute inset-0 w-6 h-6 sm:w-8 sm:h-8 bg-primary/20 rounded-full animate-pulse"></div>
                       </div>
                       <div className="font-space-age font-black bg-gradient-neon bg-clip-text">
                         <div className="text-lg sm:text-xl lg:text-2xl leading-tight">MATHENOID</div>
                         <div className="text-xs sm:text-sm lg:text-base leading-tight">ICT LAB</div>
                       </div>
                     </Link>
            <p className="text-sm mb-6 leading-relaxed font-cyber text-muted-foreground">
              Transcending digital boundaries through Software Engineering. 
              Engineering tomorrow's reality today.
            </p>
            <Badge variant="secondary" className="mb-6 font-tech tracking-wider neon-border">
              SYSTEM QUALITY ASSURED
            </Badge>
            <div className="flex gap-3">
              {socialLinks.map((social, index) => {
                const Icon = social.icon;
                return (
                  <Button
                    key={index}
                    variant="outline"
                    size="icon"
                    className="neon-border hover:bg-primary hover:text-primary-foreground hover:border-primary transition-all duration-300 group"
                    asChild
                  >
                    <a href={social.href} aria-label={social.label}>
                      <Icon className="w-4 h-4 group-hover:scale-110 transition-transform" />
                    </a>
                  </Button>
                );
              })}
            </div>
          </div>

          {/* Cyber Quick Links */}
          <div>
            <h3 className="text-lg font-semibold mb-6 font-space-age text-primary">NAVIGATION</h3>
            <ul className="space-y-4">
              {quickLinks.map((link, index) => (
                <li key={index} className="group">
                  <a 
                    href={link.href}
                    className="text-sm hover:text-primary transition-all duration-300 font-tech tracking-wider flex items-center"
                  >
                    <span className="w-2 h-2 bg-primary rounded-full mr-3 opacity-0 group-hover:opacity-100 transition-opacity"></span>
                    {link.name}
                  </a>
                </li>
              ))}
            </ul>
          </div>

          {/* Cyber Services */}
          <div>
            <h3 className="text-lg font-semibold mb-6 font-space-age text-primary">PROTOCOLS</h3>
            <ul className="space-y-4">
              {cyberServices.map((service, index) => (
                <li key={index} className="group">
                  <span className="text-sm hover:text-primary transition-all duration-300 cursor-pointer font-tech tracking-wide flex items-center">
                    <Cpu className="w-3 h-3 mr-3 text-primary/50 group-hover:text-primary transition-all" />
                    {service}
                  </span>
                </li>
              ))}
            </ul>
          </div>

          {/* Cyber Contact Info */}
          <div>
            <h3 className="text-lg font-semibold mb-6 font-space-age text-primary">TRANSMISSION</h3>
            <div className="space-y-6">
              <div className="flex items-start gap-4 group">
                <CyberIcon icon={Mail} className="mt-1 text-primary flex-shrink-0" />
                <div>
                  <p className="text-sm font-medium font-tech">MAIL STREAM</p>
                  <p className="text-sm font-mono-future">admin@mathenoid.com</p>
                </div>
              </div>
              <div className="flex items-start gap-4 group">
                <CyberIcon icon={Phone} className="mt-1 text-primary flex-shrink-0" />
                <div>
                  <p className="text-sm font-medium font-tech">PHONE LINK</p>
                  <p className="text-sm font-mono-future">+254 740 46 7735</p>
                </div>
              </div>
              <div className="flex items-start gap-4 group">
                <CyberIcon icon={MapPin} className="mt-1 text-primary flex-shrink-0" />
                <div>
                  <p className="text-sm font-medium font-tech">COORDINATES</p>
                  <p className="text-sm font-mono-future">JUJA, Kenya</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <Separator className="opacity-20 neon-border" />

      {/* Cyber Bottom Footer */}
      <div className="container mx-auto px-4 sm:px-6 lg:px-8 py-8 relative z-10">
        <div className="flex flex-col sm:flex-row justify-between items-center gap-6">
          <div className="text-sm text-center sm:text-left font-cyber">
            <p className="flex items-center justify-center sm:justify-start">
              <span className="font-space-age text-primary mr-2">©</span>
              {currentYear} MATHENOID ICT LAB. ALL RIGHTS RESERVED.
              <span className="inline-flex items-center ml-3">
                CRAFTED WITH <Heart className="w-3 h-3 mx-2 text-red-500 animate-pulse" />BY <span className='font-tech text-cyan-900 text-sm'>&nbsp; Nyaga Mbugua</span>  
              </span>
            </p>
          </div>
          
          <div className="flex items-center gap-6">
            <div className="flex gap-6 text-sm font-tech">
              <a href="#" className="hover:text-primary transition-colors tracking-wider">PRIVACY.PROTOCOL</a>
              <a href="#" className="hover:text-primary transition-colors tracking-wider">TERMS.SYS</a>
            </div>
            
            {/* Cyber Scroll to Top */}
            <Button
              variant="outline"
              size="icon"
              onClick={scrollToTop}
              className="neon-border hover:bg-primary hover:text-primary-foreground hover:border-primary transition-all duration-300 group"
            >
              <ArrowUp className="w-4 h-4 group-hover:scale-110 group-hover:-translate-y-1 transition-transform" />
            </Button>
          </div>
        </div>
      </div>
      
      {/* Bottom scanning line */}
      <div className="absolute bottom-0 left-0 right-0 h-px bg-gradient-to-r from-transparent via-primary to-transparent animate-data-stream" style={{ animationDirection: 'reverse' }}></div>
    </footer>
  );
};