import { Stack } from "expo-router";
import React from "react";
import UserContextProvider from "../contexts/UserContextProvider";
import { useFonts } from "expo-font";

const RootLayout = () => {
  //adding the fonts to use in the layouts' screens
  const [fontsLoaded] = useFonts({
    outfit: require("../assets/fonts/Outfit-Regular.ttf"),
    "outfit-bold": require("../assets/fonts/Outfit-Bold.ttf"),
    "outfit-extra-bold": require("../assets/fonts/Outfit-ExtraBold.ttf"),
    "outfit-semi-bold": require("../assets/fonts/Outfit-SemiBold.ttf"),
    "outfit-medium": require("../assets/fonts/Outfit-Medium.ttf"),
    "outfit-thin": require("../assets/fonts/Outfit-Thin.ttf"),
    poppins: require("../assets/fonts/Poppins-Black.ttf"),
    "poppins-italic": require("../assets/fonts/Poppins-Italic.ttf"),
  });

  if (!fontsLoaded) {
    return null; // or a loading component
  }

  return (
    <UserContextProvider>
      <Stack
        screenOptions={{
          headerShown: false, // This will hide the header and back arrow globally
        }}
      >
        <Stack.Screen name="index" />
        <Stack.Screen name="signup" />
        <Stack.Screen name="(drawer)" />
        <Stack.Screen name="ForgotPassword" />
      </Stack>
    </UserContextProvider>
  );
};

export default RootLayout;
