
// import { Linkedin, Github } from 'lucide-react';
// import { useState } from "react";

// export const ContactSection = () => {
//   const [formData, setFormData] = useState({
//     name: "",
//     email: "",
//     subject: "",
//     message: "",
//   });
//   const [isSubmitting, setIsSubmitting] = useState(false);
//   const [submitStatus, setSubmitStatus] = useState(null);

//   const handleInputChange = (e) => {
//     const { name, value } = e.target;
//     setFormData((prev) => ({
//       ...prev,
//       [name]: value,
//     }));
//   };

//   const handleWhatsAppClick = () => {
//     const whatsappUrl =
//       "https://wa.me/254740467735?text=I'm%20interested%20in%20your%20services%20kindly%20contact";
//     window.open(whatsappUrl, "_blank");
//   };

//   const showToast = (title, description, variant = "default") => {
//     setSubmitStatus({ title, description, variant });
//     setTimeout(() => setSubmitStatus(null), 5000);
//   };

//   const handleSubmit = async () => {
//     if (!formData.name || !formData.email || !formData.subject || !formData.message) {
//       showToast("Validation Error", "Please fill in all required fields.", "error");
//       return;
//     }

//     setIsSubmitting(true);

//     try {
//       // Map form data to backend expected format
//       const [firstName, ...lastNameParts] = formData.name.trim().split(' ');
//       const lastName = lastNameParts.join(' ') || firstName;
      
//       const backendData = {
//         firstName: firstName,
//         lastName: lastName,
//         email: formData.email,
//         message: `Subject: ${formData.subject}\n\n${formData.message}`,
//         service: 'General Inquiry',
//         phone: '',
//         budget: ''
//       };

//       const response = await fetch('http://localhost:3001/api/contact', {
//         method: 'POST',
//         headers: {
//           'Content-Type': 'application/json',
//         },
//         body: JSON.stringify(backendData),
//       });

//       const result = await response.json();

//       if (result.success) {
//         showToast("Message Sent Successfully! 🎉", "Thank you for your inquiry. We'll get back to you within 2 hours during business days.", "success");
//         setFormData({ name: "", email: "", subject: "", message: "" });
//       } else {
//         throw new Error(result.message || 'Failed to send message');
//       }
//     } catch (error) {
//       console.error('Form submission error:', error);
//       showToast("Message Failed to Send", "Something went wrong. Please try again or contact us directly via WhatsApp.", "error");
//     } finally {
//       setIsSubmitting(false);
//     }
//   };

//   const contactInfo = [
//     {
//       icon: "📧",
//       title: "Email",
//       value: "admin@mathenoid.com",
//       description: "Send us an email anytime",
//     },
//     {
//       icon: "📞",
//       title: "Phone",
//       value: "+254 740467735",
//       description: "Call us for immediate assistance",
//     },
//     {
//       icon: "📍",
//       title: "Location",
//       value: "JUJA, Kenya",
//       description: "East Africa Hub",
//     },
//     {
//       icon: "🕒",
//       title: "Business Hours",
//       value: "Mon - Fri: 9AM - 6PM",
//       description: "EAT (UTC+3)",
//     },
//   ];

// const socialLinks = [
//     {
//       icon: "🔗",
//       href: "https://www.linkedin.com/in/kelvin-nyagah-07b369255",
//       label: "LinkedIn",
//     },
//     {
//       icon: "🐙",
//       href: "https://www.github.com/mathenoidke",
//       label: "GitHub",
//     },
// ];


//   return (
//     <section className="py-20 bg-gradient-to-br from-slate-50 to-blue-50 dark:from-slate-900 dark:to-slate-800">
//       <div className="container mx-auto px-4 sm:px-6 lg:px-8 max-w-7xl">
//         {/* Toast Notification */}
//         {submitStatus && (
//           <div className={`fixed top-4 right-4 z-50 p-4 rounded-lg shadow-lg max-w-md ${
//             submitStatus.variant === 'error' ? 'bg-red-500 text-white' : 
//             submitStatus.variant === 'success' ? 'bg-green-500 text-white' : 
//             'bg-blue-500 text-white'
//           }`}>
//             <h4 className="font-semibold">{submitStatus.title}</h4>
//             <p className="text-sm mt-1">{submitStatus.description}</p>
//           </div>
//         )}

//         {/* Section Header */}
//         <div className="text-center mb-16">
//           <div className="inline-block px-4 py-2 mb-4 border border-blue-200 text-blue-600 rounded-full text-sm">
//             Get In Touch
//           </div>
//           <h2 className="text-3xl sm:text-4xl lg:text-5xl font-bold mb-6 text-slate-900 dark:text-white">
//             Let's Build
//             <span className="block bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent">
//               Something Amazing
//             </span>
//           </h2>
//           <p className="text-lg text-slate-600 dark:text-slate-300 max-w-2xl mx-auto">
//             Ready to transform your ideas into reality? We're here to help you
//             navigate the digital landscape with innovative solutions tailored to
//             your needs.
//           </p>
//         </div>

//         <div className="grid lg:grid-cols-3 gap-12">
//           {/* Contact Information */}
//           <div className="lg:col-span-1">
//             <h3 className="text-2xl font-bold mb-6 text-slate-900 dark:text-white">Contact Information</h3>

//             <div className="space-y-6 mb-8">
//               {contactInfo.map((info, index) => (
//                 <div key={index} className="flex items-start gap-4">
//                   <div className="w-12 h-12 bg-gradient-to-br from-blue-500 to-purple-600 rounded-lg flex items-center justify-center flex-shrink-0 text-white text-xl">
//                     {info.icon}
//                   </div>
//                   <div>
//                     <h4 className="font-semibold text-slate-900 dark:text-white mb-1">
//                       {info.title}
//                     </h4>
//                     <p className="text-blue-600 dark:text-blue-400 font-medium mb-1">
//                       {info.value}
//                     </p>
//                     <p className="text-sm text-slate-600 dark:text-slate-400">
//                       {info.description}
//                     </p>
//                   </div>
//                 </div>
//               ))}
//             </div>

//             {/* Social Links */}
//             <div>
//               <h4 className="font-semibold mb-4 text-slate-900 dark:text-white">Follow Us</h4>
//               <div className="flex gap-3">
//                 {socialLinks.map((social, index) => (
//                   <button
//                     key={index}
//                     className="w-10 h-10 border border-slate-300 dark:border-slate-600 rounded-lg flex items-center justify-center hover:bg-blue-50 dark:hover:bg-slate-700 transition-colors text-lg"
//                     onClick={() => window.open(social.href, "_blank")}
//                   >
//                     {social.icon}
//                   </button>
//                 ))}
//               </div>
//             </div>

//             {/* Quick Contact */}
//             <div className="mt-8 p-6 border border-blue-200 dark:border-slate-600 rounded-lg bg-gradient-to-br from-blue-50 to-purple-50 dark:from-slate-800 dark:to-slate-700">
//               <div className="flex items-center gap-3 mb-3">
//                 <span className="text-blue-600 text-lg">💬</span>
//                 <h4 className="font-semibold text-slate-900 dark:text-white">Quick Response</h4>
//               </div>
//               <p className="text-sm text-slate-600 dark:text-slate-300 mb-4">
//                 Need immediate assistance? We typically respond to inquiries
//                 within 2-4 hours during business days.
//               </p>
//               <button
//                 onClick={handleWhatsAppClick}
//                 className="w-full py-2 px-4 bg-green-500 hover:bg-green-600 text-white rounded-lg font-medium transition-colors"
//               >
//                 WhatsApp Chat
//               </button>
//             </div>
//           </div>

//           {/* Contact Form */}
//           <div className="lg:col-span-2">
//             <div className="bg-white dark:bg-slate-800 rounded-xl shadow-xl p-8">
//               <h3 className="text-2xl font-bold mb-6 text-slate-900 dark:text-white">Send us a Message</h3>
              
//               <div className="space-y-6">
//                 <div className="grid md:grid-cols-2 gap-4">
//                   <div>
//                     <label className="block text-sm font-medium mb-2 text-slate-700 dark:text-slate-300">
//                       Full Name *
//                     </label>
//                     <input
//                       name="name"
//                       type="text"
//                       required
//                       value={formData.name}
//                       onChange={handleInputChange}
//                       placeholder="Your full name"
//                       className="w-full p-3 border border-slate-300 dark:border-slate-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-slate-700 text-slate-900 dark:text-white"
//                     />
//                   </div>
//                   <div>
//                     <label className="block text-sm font-medium mb-2 text-slate-700 dark:text-slate-300">
//                       Email Address *
//                     </label>
//                     <input
//                       name="email"
//                       type="email"
//                       required
//                       value={formData.email}
//                       onChange={handleInputChange}
//                       placeholder="your.email@example.com"
//                       className="w-full p-3 border border-slate-300 dark:border-slate-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-slate-700 text-slate-900 dark:text-white"
//                     />
//                   </div>
//                 </div>

//                 <div>
//                   <label className="block text-sm font-medium mb-2 text-slate-700 dark:text-slate-300">
//                     Subject *
//                   </label>
//                   <input
//                     name="subject"
//                     type="text"
//                     required
//                     value={formData.subject}
//                     onChange={handleInputChange}
//                     placeholder="What's this about?"
//                     className="w-full p-3 border border-slate-300 dark:border-slate-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-slate-700 text-slate-900 dark:text-white"
//                   />
//                 </div>

//                 <div>
//                   <label className="block text-sm font-medium mb-2 text-slate-700 dark:text-slate-300">
//                     Message *
//                   </label>
//                   <textarea
//                     name="message"
//                     required
//                     value={formData.message}
//                     onChange={handleInputChange}
//                     placeholder="Tell us about your project or inquiry..."
//                     rows={6}
//                     className="w-full p-3 border border-slate-300 dark:border-slate-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 resize-none bg-white dark:bg-slate-700 text-slate-900 dark:text-white"
//                   />
//                 </div>

//                 <button
//                   onClick={handleSubmit}
//                   disabled={isSubmitting}
//                   className="w-full py-3 px-6 bg-gradient-to-r from-blue-500 to-purple-600 hover:from-blue-600 hover:to-purple-700 disabled:opacity-50 disabled:cursor-not-allowed text-white rounded-lg font-medium transition-all duration-200 flex items-center justify-center gap-2"
//                 >
//                   {isSubmitting ? (
//                     <>
//                       <div className="animate-spin rounded-full h-4 w-4 border-2 border-white border-t-transparent"></div>
//                       Sending...
//                     </>
//                   ) : (
//                     <>
//                       Send Message
//                       <span>📤</span>
//                     </>
//                   )}
//                 </button>
//               </div>
//             </div>
//           </div>
//         </div>
//       </div>
//     </section>
//   );
// };



import { Linkedin, Github } from 'lucide-react';
import { useState } from "react";

export const ContactSection = () => {
  const [formData, setFormData] = useState({
    name: "",
    email: "",
    subject: "",
    message: "",
  });
  const [isSubmitting, setIsSubmitting] = useState(false);
  const [submitStatus, setSubmitStatus] = useState(null);

  const handleInputChange = (e) => {
    const { name, value } = e.target;
    setFormData((prev) => ({
      ...prev,
      [name]: value,
    }));
  };

  const handleWhatsAppClick = () => {
    const whatsappUrl =
      "https://wa.me/254740467735?text=I'm%20interested%20in%20your%20services%20kindly%20contact";
    window.open(whatsappUrl, "_blank");
  };

  const showToast = (title, description, variant = "default") => {
    setSubmitStatus({ title, description, variant });
    setTimeout(() => setSubmitStatus(null), 5000);
  };

  const handleSubmit = async () => {
    if (!formData.name || !formData.email || !formData.subject || !formData.message) {
      showToast("Validation Error", "Please fill in all required fields.", "error");
      return;
    }

    setIsSubmitting(true);

    try {
      // Map form data to backend expected format
      const [firstName, ...lastNameParts] = formData.name.trim().split(' ');
      const lastName = lastNameParts.join(' ') || firstName;
      
      const backendData = {
        firstName: firstName,
        lastName: lastName,
        email: formData.email,
        message: `Subject: ${formData.subject}\n\n${formData.message}`,
        service: 'General Inquiry',
        phone: '',
        budget: ''
      };

      const response = await fetch('http://localhost:3001/api/contact', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify(backendData),
      });

      const result = await response.json();

      if (result.success) {
        showToast("Message Sent Successfully! 🎉", "Thank you for your inquiry. We'll get back to you within 2 hours during business days.", "success");
        setFormData({ name: "", email: "", subject: "", message: "" });
      } else {
        throw new Error(result.message || 'Failed to send message');
      }
    } catch (error) {
      console.error('Form submission error:', error);
      showToast("Message Failed to Send", "Something went wrong. Please try again or contact us directly via WhatsApp.", "error");
    } finally {
      setIsSubmitting(false);
    }
  };

  const contactInfo = [
    {
      icon: "📧",
      title: "Email",
      value: "admin@mathenoid.com",
      description: "Send us an email anytime",
    },
    {
      icon: "📞",
      title: "Phone",
      value: "+254 740467735",
      description: "Call us for immediate assistance",
    },
    {
      icon: "📍",
      title: "Location",
      value: "JUJA, Kenya",
      description: "East Africa Hub",
    },
    {
      icon: "🕒",
      title: "Business Hours",
      value: "Mon - Fri: 9AM - 6PM",
      description: "EAT (UTC+3)",
    },
  ];

  const socialLinks = [
    {
      icon: Linkedin,
      href: "https://www.linkedin.com/in/kelvin-nyagah-07b369255",
      label: "LinkedIn",
    },
    {
      icon: Github,
      href: "https://www.github.com/mathenoidke",
      label: "GitHub",
    },
  ];

  return (
    <section className="py-20 bg-gradient-to-br from-slate-50 to-blue-50 dark:from-slate-900 dark:to-slate-800">
      <div className="container mx-auto px-4 sm:px-6 lg:px-8 max-w-7xl">
        {/* Toast Notification */}
        {submitStatus && (
          <div className={`fixed top-4 right-4 z-50 p-4 rounded-lg shadow-lg max-w-md ${
            submitStatus.variant === 'error' ? 'bg-red-500 text-white' : 
            submitStatus.variant === 'success' ? 'bg-green-500 text-white' : 
            'bg-blue-500 text-white'
          }`}>
            <h4 className="font-semibold">{submitStatus.title}</h4>
            <p className="text-sm mt-1">{submitStatus.description}</p>
          </div>
        )}

        {/* Section Header */}
        <div className="text-center mb-16">
          <div className="inline-block px-4 py-2 mb-4 border border-blue-200 text-blue-600 rounded-full text-sm">
            Get In Touch
          </div>
          <h2 className="text-3xl sm:text-4xl lg:text-5xl font-bold mb-6 text-slate-900 dark:text-white">
            Let's Build
            <span className="block bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent">
              Something Amazing
            </span>
          </h2>
          <p className="text-lg text-slate-600 dark:text-slate-300 max-w-2xl mx-auto">
            Ready to transform your ideas into reality? We're here to help you
            navigate the digital landscape with innovative solutions tailored to
            your needs.
          </p>
        </div>

        <div className="grid lg:grid-cols-3 gap-12">
          {/* Contact Information */}
          <div className="lg:col-span-1">
            <h3 className="text-2xl font-bold mb-6 text-slate-900 dark:text-white">Contact Information</h3>

            <div className="space-y-6 mb-8">
              {contactInfo.map((info, index) => (
                <div key={index} className="flex items-start gap-4">
                  <div className="w-12 h-12 bg-gradient-to-br from-blue-500 to-purple-600 rounded-lg flex items-center justify-center flex-shrink-0 text-white text-xl">
                    {info.icon}
                  </div>
                  <div>
                    <h4 className="font-semibold text-slate-900 dark:text-white mb-1">
                      {info.title}
                    </h4>
                    <p className="text-blue-600 dark:text-blue-400 font-medium mb-1">
                      {info.value}
                    </p>
                    <p className="text-sm text-slate-600 dark:text-slate-400">
                      {info.description}
                    </p>
                  </div>
                </div>
              ))}
            </div>

            {/* Social Links */}
            <div>
              <h4 className="font-semibold mb-4 text-slate-900 dark:text-white">Follow Us</h4>
              <div className="flex gap-3">
                {socialLinks.map((social, index) => {
                  const IconComponent = social.icon;
                  return (
                    <button
                      key={index}
                      className="w-10 h-10 border border-slate-300 dark:border-slate-600 rounded-lg flex items-center justify-center hover:bg-blue-50 dark:hover:bg-slate-700 transition-colors"
                      onClick={() => window.open(social.href, "_blank")}
                      aria-label={social.label}
                    >
                      <IconComponent size={20} className="text-slate-600 dark:text-slate-400 hover:text-blue-600 dark:hover:text-blue-400" />
                    </button>
                  );
                })}
              </div>
            </div>

            {/* Quick Contact */}
            <div className="mt-8 p-6 border border-blue-200 dark:border-slate-600 rounded-lg bg-gradient-to-br from-blue-50 to-purple-50 dark:from-slate-800 dark:to-slate-700">
              <div className="flex items-center gap-3 mb-3">
                <span className="text-blue-600 text-lg">💬</span>
                <h4 className="font-semibold text-slate-900 dark:text-white">Quick Response</h4>
              </div>
              <p className="text-sm text-slate-600 dark:text-slate-300 mb-4">
                Need immediate assistance? We typically respond to inquiries
                within 2-4 hours during business days.
              </p>
              <button
                onClick={handleWhatsAppClick}
                className="w-full py-2 px-4 bg-green-500 hover:bg-green-600 text-white rounded-lg font-medium transition-colors"
              >
                WhatsApp Chat
              </button>
            </div>
          </div>

          {/* Contact Form */}
          <div className="lg:col-span-2">
            <div className="bg-white dark:bg-slate-800 rounded-xl shadow-xl p-8">
              <h3 className="text-2xl font-bold mb-6 text-slate-900 dark:text-white">Send us a Message</h3>
              
              <div className="space-y-6">
                <div className="grid md:grid-cols-2 gap-4">
                  <div>
                    <label className="block text-sm font-medium mb-2 text-slate-700 dark:text-slate-300">
                      Full Name *
                    </label>
                    <input
                      name="name"
                      type="text"
                      required
                      value={formData.name}
                      onChange={handleInputChange}
                      placeholder="Your full name"
                      className="w-full p-3 border border-slate-300 dark:border-slate-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-slate-700 text-slate-900 dark:text-white"
                    />
                  </div>
                  <div>
                    <label className="block text-sm font-medium mb-2 text-slate-700 dark:text-slate-300">
                      Email Address *
                    </label>
                    <input
                      name="email"
                      type="email"
                      required
                      value={formData.email}
                      onChange={handleInputChange}
                      placeholder="your.email@example.com"
                      className="w-full p-3 border border-slate-300 dark:border-slate-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-slate-700 text-slate-900 dark:text-white"
                    />
                  </div>
                </div>

                <div>
                  <label className="block text-sm font-medium mb-2 text-slate-700 dark:text-slate-300">
                    Subject *
                  </label>
                  <input
                    name="subject"
                    type="text"
                    required
                    value={formData.subject}
                    onChange={handleInputChange}
                    placeholder="What's this about?"
                    className="w-full p-3 border border-slate-300 dark:border-slate-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-slate-700 text-slate-900 dark:text-white"
                  />
                </div>

                <div>
                  <label className="block text-sm font-medium mb-2 text-slate-700 dark:text-slate-300">
                    Message *
                  </label>
                  <textarea
                    name="message"
                    required
                    value={formData.message}
                    onChange={handleInputChange}
                    placeholder="Tell us about your project or inquiry..."
                    rows={6}
                    className="w-full p-3 border border-slate-300 dark:border-slate-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 resize-none bg-white dark:bg-slate-700 text-slate-900 dark:text-white"
                  />
                </div>

                <button
                  onClick={handleSubmit}
                  disabled={isSubmitting}
                  className="w-full py-3 px-6 bg-gradient-to-r from-blue-500 to-purple-600 hover:from-blue-600 hover:to-purple-700 disabled:opacity-50 disabled:cursor-not-allowed text-white rounded-lg font-medium transition-all duration-200 flex items-center justify-center gap-2"
                >
                  {isSubmitting ? (
                    <>
                      <div className="animate-spin rounded-full h-4 w-4 border-2 border-white border-t-transparent"></div>
                      Sending...
                    </>
                  ) : (
                    <>
                      Send Message
                      <span>📤</span>
                    </>
                  )}
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};